IF NOT OBJECT_ID('[TRG_EST_PED_CP_INCLUI_EXCLUI_PENDENCIA]') IS NULL
	BEGIN
			DROP TRIGGER TRG_EST_PED_CP_INCLUI_EXCLUI_PENDENCIA
	END
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER [dbo].[TRG_EST_PED_CP_INCLUI_EXCLUI_PENDENCIA]
ON [dbo].[EST_PED_CP]
FOR UPDATE
AS
		DECLARE @STS_PED_CP VARCHAR(20)
		DECLARE @CD_EMP INT
		DECLARE @CD_FILIAL INT
		DECLARE @CD_PED INT

		IF ( NOT UPDATE(DT_CANCEL)  OR
				 NOT UPDATE (DT_ULT_ATU)  OR
				 NOT UPDATE (CD_USU) )
			BEGIN
					RETURN
			END

		SELECT
			@CD_EMP = CD_EMP
			,@CD_FILIAL = CD_FILIAL
			,@CD_PED = CD_PED
		FROM
			DELETED;

		SELECT
			@STS_PED_CP = dbo.TST_EST_PED_CP_STATUS(@CD_EMP, @CD_FILIAL, @CD_PED)
		OPTION (RECOMPILE);

		--------------------------------------ALTERAO EM EST_PED_CP--------------------------------------
		--Probe alterao no pedido de compra quando j existe registro da nota de entrada
		IF EXISTS (SELECT
								 *
							 FROM
								 EST_NF_ENT_PED_CP t
								 INNER JOIN DELETED s ON
									 t.CD_FILIAL = s.CD_FILIAL AND
									 t.CD_EMP = s.CD_EMP AND
									 t.CD_PED = s.CD_PED)
			BEGIN
					IF @STS_PED_CP = 'PEDIDO COM ENTREGA TOTAL'
						BEGIN
								RAISERROR ('Nao pode haver alteracao do pedido com entrada de mercadoria.',16,1);

								ROLLBACK TRANSACTION;

								RETURN;
						END
			END

		IF @STS_PED_CP <> 'PEDIDO COM ENTREGA TOTAL'
			BEGIN
					--Pendncia de entrada pedido de compras
					INSERT INTO EST_PED_CP_PENDENCIA
											(CD_EMP,
											 CD_FILIAL,
											 CD_PED)
					SELECT
						CD_EMP
						,CD_FILIAL
						,CD_PED
					FROM
						INSERTED c
					WHERE
						DBO.TST_EST_PED_CP_STATUS(CD_EMP, CD_FILIAL, CD_PED) <> 'PEDIDO COM ENTREGA TOTAL' AND
						NOT EXISTS (SELECT
													*
												FROM
													EST_PED_CP_PENDENCIA
												WHERE
												 c.CD_FILIAL = CD_FILIAL AND
												 c.CD_EMP    = CD_EMP AND
												 c.CD_PED    = CD_PED);
			END

		DELETE FROM f
		FROM   EST_PED_CP_PENDENCIA f
					 INNER JOIN INSERTED s ON
						 f.CD_FILIAL = s.CD_FILIAL AND
						 f.CD_EMP = s.CD_EMP AND
						 f.CD_PED = s.CD_PED
		WHERE  s.STS_PED IN ( 2, 4 )  OR
					 s.NAO_CONSTAR_PEND_ENTR <> 0 
